require( "quest/m3_big/convout.lua" );
combine_speech_tables();

flo_anim_table =
{
	"anim/flo/stands", "anim/flo/standse", "anim/flo/talksegestures",
	"anim/flo/talks",
	"anim/flo/talkse",
	"anim/flo/walke",
	"anim/flo/walkn",
	"anim/flo/walkne",
	"anim/flo/walks",
	"anim/flo/walkse",
};

flo_spec =
{
	name = "FLO";
	halo = "quest/objects/flo";
	anim = flo_anim_table;
	cantuse = "obj_flo_cantuse";
	
	command = function(actor)
		prepare_actor_text(actor, flo_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:SetDepthMode(DEPTH.DEPTH_BY_Y);		-- depth by y
		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:AddFlag(AFLAG.AFLAG_NO_GROUND_CLICKS);
		actor:AddFlag(AFLAG.AFLAG_SCALE_BY_Y);	-- enable ground-based scaling
		actor:SetWalkSpeed(flo_speed);
		
		local lastScene = game:GetLastScene();
		
		if lastScene == "m3_lobby" or lastScene == "m3_maze3" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("to_lobby");
			scene:SetCameraFollowActor(scene.CAMERA);
			scene.CAMERA:JumpToNamedPoint("flo_west");
			actor:WalkTo("flo_west");
			wait_walkto();
			
			spawn_nav_arrow(door_lobby_spec);
		elseif lastScene == "m3_flowershop" then
			actor:FaceNow(DIR.S);
			actor:JumpToNamedPoint("to_flower");
			scene:SetCameraFollowActor(scene.CAMERA);
			scene.CAMERA:JumpToNamedPoint("flo_east");
			actor:WalkTo("flo_east");
			wait_walkto();
			
			spawn_nav_arrow(door_flower_spec);
		else -- lastScene == "m3_intersection"
			actor:JumpToNamedPoint("flo_intersection");
			actor:FaceNow(DIR.W);
			actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
			scene:SetCameraFollowActor(actor);
			actor:WalkTo("flo_east");
			game:SetString("map_position", "m3_flower");			
			wait_walkto();
			
			spawn_nav_arrow(door_flower_spec);
			
			scene.CAMERA:JumpToNamedPoint("flo_east");
			scene:SetCameraFollowActor(scene.CAMERA);
		end
		
		actor:Face(DIR.S);
		actor:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetMode(MODE.FOLLOWCLICKS);
	end;
	
	on_arrive = function(flo, flo2)
		flo:StartProc(flo_talk);
	end;
	
	on_use_inv = function(item, flo, flo2)
		flo_inv_generic(flo, item);
		return RESPONSE.INV_HANDLED;
	end;
};

function flo_talk(flo)
	flo:SetMode(MODE.CUTSCENE);
	if game:GetString("map_position") == "m3_lobby" then
		run_super_conversation(flo, "quip_flo_big_ave");
	else
		run_super_conversation(flo, "quip_flo_general");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

function gotolobby(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("to_lobby");
	delay(30);
	
	goto_scene(flo, "m3_lobby");
end

door_lobby_spec = 
{
	name = "DOOR_LOBBY";
	halo = "to_lobby";
	cursor = "cursor_arrow_n";
	goto_fn = gotolobby;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE then
			if enter then
				scene.DOOR_LOBBY_ANIM:PlayAnim("Open");
			else
				scene.DOOR_LOBBY_ANIM:PlayAnim("Close");
			end
		end
	end;
}

door_lobby_anim_spec =
{
	name = "DOOR_LOBBY_ANIM";
	gfx = {anim = "anim/m3_big/door_big"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("10");
	end;
}

function gotoflower(flo)
	flo:SetMode(MODE.CUTSCENE);
	flo:WalkTo("to_flower");
	delay(30);
	
	goto_scene(flo, "m3_flowershop");
end

door_flower_spec = 
{
	name = "DOOR_FLOWER";
	halo = "to_flower";
	cursor = "cursor_arrow_n";
	goto_fn = gotoflower;
	point_at_fn = function(actor, enter)
		if actor:GetMode() ~= MODE.CUTSCENE then
			if enter then
				scene.DOOR_FLOWER_ANIM:PlayAnim("Open");
			else
				scene.DOOR_FLOWER_ANIM:PlayAnim("Close");
			end
		end
	end;
}

door_flower_anim_spec =
{
	name = "DOOR_FLOWER_ANIM";
	gfx = {anim = "anim/m3_big/door_flowershop"};
	
	command = function(actor)
		actor:PlayAnim("Closed");
		actor:SetDepthValue("10");
	end;
}

function gotointersection(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_FLOWER:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("to_intersection");
	delay(150);
	goto_scene(flo, "m3_intersection", true);
end

to_intersection_spec = 
{
	name = "TO_INTERSECTION";
	halo = "to_intersection";
	cursor = "cursor_arrow_e";
	goto_fn = gotointersection;
}

function gotobigwest(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_FLOWER:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("flo_west");
	wait_walkto();
	flo:Face(DIR.S);
	
	spawn_nav_arrow(door_lobby_spec);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("flo_west");
	scene:SetCameraFollowActor(scene.CAMERA);
	
	game:SetString("map_position", "m3_lobby");
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_bigwest_spec = 
{
	name = "TO_BIGWEST";
	halo = "to_bigwest";
	cursor = "cursor_arrow_w";
	goto_fn = gotobigwest;
}

function gotobigeast(flo)
	flo:SetMode(MODE.CUTSCENE);
	scene.DOOR_LOBBY:Expire();
	flo:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene:SetCameraFollowActor(scene.FLO);
	flo:WalkTo("camera_bigeast");
	wait_walkto();
	flo:Face(DIR.S);
	
	spawn_nav_arrow(door_flower_spec);
	
	flo:ClearFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
	scene.CAMERA:JumpToNamedPoint("camera_bigeast");
	scene:SetCameraFollowActor(scene.CAMERA);
	
	game:SetString("map_position", "m3_flower");
	
	flo:SetMode(MODE.FOLLOWCLICKS);
end

to_bigeast_spec = 
{
	name = "TO_BIGEAST";
	halo = "to_bigeast";
	cursor = "cursor_arrow_e";
	goto_fn = gotobigeast;
}

camera_spec = 
{
	name = "CAMERA";
	command = function(actor)

		actor:AddFlag(AFLAG.AFLAG_IGNORE_GROUND_MESH);
		actor:SetWalkSpeed(6);
		
		if game:GetLastScene() == "m3_intersection" then
			actor:JumpToNamedPoint("flo_intersection");
		end
	end;
};

karma_anim_table = 
{
	"anim/karma/stand",
	"anim/karma/talkw",
};

karma_spec = 
{
	name = "KARMA";
	halo = "quest/objects/karma";
	anim = karma_anim_table;
	
	command = function(actor)
		prepare_actor_text(actor, karma_text_spec);
 
		--actor:AddFlag(AFLAG.AFLAG_USE_LIGHTMAP);	-- enable ground-based lighting
		--actor:AddFlag(AFLAG.AFLAG_X_FLIPPABLE);
		actor:JumpToNamedPoint("karma");
		actor:SetWalkSpeed(karma_speed);
		actor:SetDepthValue( 800 );
		actor:SetScale( 1.0 );
	end;
	
	on_arrive = function(flo, karma)
		flo:StartProc(talk_to_karma);
	end;
};

function talk_to_karma(flo)
	flo:SetMode(MODE.CUTSCENE);
	if ( game:Get( "talked_to_karma" ) == 0 ) then
		run_super_conversation(flo, "conv_karma_A");
		game:Set( "talked_to_karma", 1 );
	elseif ( ( game:Get( "bouquets_delivered" ) ~= 1 ) or ( game:Get( "found_bernie" ) == 1 ) ) then
		run_super_conversation(flo, "conv_karma_B");
	else
		run_super_conversation(flo, "conv_karma_bernie");
	end
	flo:SetMode(MODE.FOLLOWCLICKS);
end

big_corp_sign_spec = 
{
	name = "BIG_CORP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/revue_std.mvec",
			color = { a = 1, r = 0, g = 0, b = 0.4 },
			outline_size = 0,
			lineheight = 50,
			linepadding = 2,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_big_corp_sign");
		actor:StopWalking();
		actor:SetPolygon({x=348,y=108}, {x=454,y=110}, {x=348,y=168}, {x=453,y=167});
		actor:TextToImage(10, 10);
	end;
}

flower_shop_sign_spec = 
{
	name = "FLOWER_SHOP_SIGN";
	
	command = function(actor)
		actor:SetDepthValue(500);
		actor:ModifySaySpec
		{
			font = "fonts/spumoni_lp_std.mvec",
			color = { a = 1, r = 0.8, g = 0, b = 0 },
			--outline_size = 0,
			lineheight = 42,
			linepadding = -7,
		}
		
		actor:SetAlpha(1.0);
		
		actor:Say("text_flower_shop_sign");
		actor:StopWalking();
		actor:SetPolygon({x=1286,y=120}, {x=1608,y=120}, {x=1286,y=149}, {x=1608,y=149});
		actor:TextToImage(35, 0);
	end;
}

scene_setup =
{
	name = "SETUP",
	command = function(actor)
		sfx:SetMusic("audio/music/music_streets3.ogg", true);
		sfx:PlaySFX("audio/sfx/ambient_mod1.ogg", true);
		--scene:SetRoomScale(300, 550, 0.7, 1.1);	--topline, bottomline, topscale, bottomscale
		
		--fade_scene_up();
		
		if IsCheatMode() then
			-- testing data
		end
		
		spawn_nav_arrow(to_intersection_spec);
		spawn_nav_arrow(to_bigwest_spec);
		spawn_nav_arrow(to_bigeast_spec);
		
		scene:SetRoomScale(300, 550, 0.5, 0.7);	--topline, bottomline, topscale, bottomscale
		
		local no_fade = game:GetLastScene() == "m3_intersection";
		fade_scene_up(false, no_fade);
		
		--scene:SetCameraFollowActor(scene.CAMERA);		-- Attach the camera to follow "CAMERA" actor
		scene:SetCameraMargin { x = 400, y = 300 };
		
		spawn_simple_hotspot("end_of_street", 5);
		spawn_simple_hotspot("big_seahorse", 5);
	end;
};

scene_spec =
{
	atlas = 
	{
		"pieces", -- load pieces
	};
	
	bg_image = 
	{
		{ "background", DEPTH.DEPTH_BACKMOST  },
		
		{ "car01", DEPTH.DEPTH_FRONTMOST },
		{ "car02", DEPTH.DEPTH_FRONTMOST },

		--{ "foreground", DEPTH.DEPTH_FRONTMOST },
	};
	
	--lightmap = "lightmap";	-- use the ground as the lightmap
	
	ground = "background";
	
	actorlist = 
	{ 
		camera_spec,
		scene_setup,
		--karma_spec,
		
		flo_spec, -- the main actor
		
		door_lobby_anim_spec,
		door_flower_anim_spec,
		
		big_corp_sign_spec,
		flower_shop_sign_spec,
	};
};
